/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public class WailaExceptionHandler {
    private static final Set<IJadeProvider> ERRORS = Sets.newConcurrentHashSet();
    private static boolean NULL_ERROR = false;
    private static final File ERROR_OUTPUT = new File("logs", "JadeErrorOutput.txt");

    public static void handleErr(Throwable e, @Nullable IJadeProvider provider, @Nullable ITooltip tooltip, @Nullable String whoToBlame) {
        if (CommonProxy.isDevEnv()) {
            ExceptionUtils.wrapAndThrow((Throwable)e);
            return;
        }
        if (provider == null) {
            if (!NULL_ERROR) {
                NULL_ERROR = true;
                WailaExceptionHandler.writeLog(e, null);
            }
        } else if (!ERRORS.contains(provider)) {
            ERRORS.add(provider);
            WailaExceptionHandler.writeLog(e, provider);
        }
        if (tooltip != null) {
            String modid = whoToBlame;
            if (provider != null) {
                modid = provider.getUid().m_135827_();
            }
            if (modid == null || "minecraft".equals(modid)) {
                modid = "jade";
            }
            tooltip.add((Component)Component.m_237110_((String)"jade.error", (Object[])new Object[]{ModIdentification.getModName(modid).orElse(modid)}).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    private static void writeLog(Throwable e, IJadeProvider provider) {
        Jade.LOGGER.error("Caught unhandled exception : [{}] {}", (Object)provider, (Object)e);
        Jade.LOGGER.error("See JadeErrorOutput.txt for more information");
        Jade.LOGGER.catching(e);
        try {
            FileUtils.writeStringToFile((File)ERROR_OUTPUT, (String)(DateFormat.getDateTimeInstance().format(new Date()) + "\n" + provider + "\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

